/*
 * sxdef.h X68k SX_SYSTEM ver 1.10 Copyright 1991 SHARP/First Class Technology
 */

typedef	void	*pointer;
typedef	void	**handle;

typedef	struct point {
	short	x;			/* w̒l	*/
	short	y;			/* x̒l	*/
} point;

#ifdef	__POINT_T
typedef	union point_t {
	point	p;
	long	l;
	long	x_y;
} point_t;
#else
typedef	long	point_t;
#endif

typedef	struct TXcsr {
	point_t		csrHot;
	unsigned short	csrMask[16];
	unsigned short	csrTXptn[4][16];
} TXcsr;

typedef	struct MsRec {
} MsRec;

typedef	struct KbRec {
} KbRec;

typedef	struct KmRec {
} KmRec;

/************************************************/
/*	} (Memory Man)			*/
/************************************************/

typedef	void	*Master;

typedef	struct Heap {
} Heap;

typedef	struct Block {
} Block;

struct hoe {
	pointer	start;
	pointer	limit;
	short	nmbMst;
	int	(*fncGrowHeap)();
};

/************************************************/
/*	Cxg} (Event Man)		*/
/************************************************/

typedef	struct event {
	short		eWhat;	/* Cxg̎			*/
	long		eWhom;	/* CxgɊ֘A		*/
	unsigned long	eWhen;	/* Cxg̔iVXeJEgj*/
	point_t		eWhere;	/* }EX̍WiO[oWnj	*/
	unsigned long	eHow;	/* L[̏			*/
} event;
/*
 *	CxgR[h
 */
#define	E_IDLE		0
#define	E_MSLDOWN	1
#define	E_MSLUP		2
#define	E_MSRDOWN	3
#define	E_MSRUP		4
#define	E_KEYDOWN	5
#define	E_KEYUP		6
#define	E_UPDATE	7
#define	E_RESERVE1	8
#define	E_ACTIVATE	9
#define	E_RESERVE2	10
#define	E_RESERVE3	11
#define	E_SYSTEM1	12
#define	E_SYSTEM2	13
#define	E_USER1		14
#define	E_USER2		15
/*
 *	eHow ̃rbgԍ
 */
#define	EH_SHFT		0		/* 1 if [SHIFT] key down	*/
#define	EH_CTRL		1		/* 1 if [CTRL] key down		*/
#define	EH_OPT1		2		/* 1 if [OPT.1] key down	*/
#define	EH_OPT2		3		/* 1 if [OPT.2] key down	*/
#define	EH_KANA		8		/* 1 if [] key down		*/
#define	EH_ROME		9		/* 1 if [OZ key down	*/
#define	EH_CDIN		10		/* 1 if [ܓ] key down	*/
#define	EH_CAPS		11		/* 1 if [CAPS] key down		*/
#define	EH_INS		12		/* 1 if [INS] key down		*/
#define	EH_HIRA		13		/* 1 if [Ђ炪] key down	*/
#define	EH_ZEN		14		/* 1 if [Sp] key down		*/
#define	EH_XF1		16		/* 1 if [XF1] key down		*/
#define	EH_XF2		17		/* 1 if [XF2] key down		*/
#define	EH_XF3		18		/* 1 if [XF3] key down		*/
#define	EH_XF4		19		/* 1 if [XF4] key down		*/
#define	EH_XF5		20		/* 1 if [XF5] key down		*/

#define	EHM_SHFT	0x000001	/* 1 if [SHIFT] key down	*/
#define	EHM_CTRL	0x000002	/* 1 if [CTRL] key down		*/
#define	EHM_OPT1	0x000004	/* 1 if [OPT.1] key down	*/
#define	EHM_OPT2	0x000008	/* 1 if [OPT.2] key down	*/
#define	EHM_KANA	0x000100	/* 1 if [] key down		*/
#define	EHM_ROME	0x000200	/* 1 if [OZ key down	*/
#define	EHM_CDIN	0x000400	/* 1 if [ܓ] key down	*/
#define	EHM_CAPS	0x000800	/* 1 if [CAPS] key down		*/
#define	EHM_INS		0x001000	/* 1 if [INS] key down		*/
#define	EHM_HIRA	0x002000	/* 1 if [Ђ炪] key down	*/
#define	EHM_ZEN		0x004000	/* 1 if [Sp] key down		*/
#define	EHM_XF1		0x010000	/* 1 if [XF1] key down		*/
#define	EHM_XF2		0x020000	/* 1 if [XF2] key down		*/
#define	EHM_XF3		0x040000	/* 1 if [XF3] key down		*/
#define	EHM_XF4		0x080000	/* 1 if [XF4] key down		*/
#define	EHM_XF5		0x100000	/* 1 if [XF5] key down		*/
/*
 *	Cxg}XN
 */
#define	EM_IDLE		0x0000
#define	EM_MSLDOWN	0x0002
#define	EM_MSLUP	0x0004
#define	EM_MSRDOWN	0x0008
#define	EM_MSRUP	0x0010
#define	EM_KEYDOWN	0x0020
#define	EM_KEYUP	0x0040
#define	EM_UPDATE	0x0080
#define	EM_RESERVE1	0x0100
#define	EM_ACTIVATE	0x0200
#define	EM_RESERVE2	0x0400
#define	EM_RESERVE3	0x0800
#define	EM_SYSTEM1	0x1000
#define	EM_SYSTEM2	0x2000
#define	EM_USER1	0x4000
#define	EM_USER2	0x8000
#define	EM_EVERY	0xFFFF
/*
 *	V[gJbgL[
 */
#define	SHORTCUT	EH_OPT1
#define	SCK_DELETE	0x2E		/* delete	[OPT.1] + 'B'	*/
#define	SCK_PASTE	0x2D		/* paste	[OPT.1] + 'V'	*/
#define	SCK_COPY	0x2C		/* copy		[OPT.1] + 'C'	*/
#define	SCK_CUT		0x2B		/* cut		[OPT.1] + 'X'	*/
#define	SCK_UNDO	0x2A		/* undo		[OPT.1] + 'Z'	*/

/************************************************/
/*	Ot} (Graph Man)			*/
/************************************************/

typedef	struct rect {			/* N^O		*/
	short	left;			/* [̍W		*/
	short	top;			/* [̍W		*/
	short	right;			/* E[̍W		*/
	short	bottom;			/* [̍W		*/
} rect;

typedef	struct region {
	int	size;			/* Ŝ̃oCg	*/
	rect	bounds;			/* ͂ގlp`		*/
} region;

typedef	struct polygon {
	int	size;			/* Ŝ̃oCg	*/
	rect	bounds;			/* ͂ގlp`		*/
} polygon;

typedef	struct LASCII {
	unsigned char	length;		/* ̃oCg	*/
	char		Lstr[255];	/* 		*/
} LASCII;

typedef	struct rectImg {		/* N^OC[W	*/
	rect		bounds;		/* ͂ގlp`		*/
	unsigned char	data;		/* C[Wf[^	*/
} rectImg;

typedef	struct tx16 {
	unsigned int	self;		/* 'TX16'		*/
	int		length;		/* ȍ~̃oCg	*/
	rect		bounds;		/* ͂ގlp`		*/
	unsigned short	palet[16];	/* PUF̃pbgl	*/
	unsigned char	data;		/* C[Wf[^	*/
} tx16;

#define	TX16sigWord	0x54583136	/* 'TX16'		*/

typedef	struct gScript {
	int		size;		/* Ŝ̃oCg	*/
	unsigned short	version;	/* o[WǗp	*/
	region		clipping;	/* O`\[W	*/
} gScript;

typedef	struct TBM {
	int		page;		/* Py[W̃oCg	*/
	unsigned short	aPage;		/* `ʂ̎w	*/
} TBM;

typedef	struct bitmap {
	short	bmKind;			/* ʂ̎		*/
	rect	bmRect;			/* ʂ̑傫		*/
	void	*base;			/* x[XAhX	*/
	short	line;			/* PC̃oCg	*/
	union {
		unsigned short	bRatio;	/* F̍킹̔䗦	*/
		TBM		tbm;
	} opt;
} bitmap;

typedef	struct graph {
	bitmap		*bmap;		/* rbg}bvւ̃|C^	*/
	rect		grRect;		/* ʃTCY			*/
	int		*procs;		/* `惋[`e[u		*/
	region		**visible;	/* `\̈̃[W	*/
	region		**clipping;	/* `\̈̃[W	*/
	short		drawLvl;	/* `惌x			*/
	unsigned short	penMode;	/* `惂[h			*/
	point_t		penLoc;		/* `ʒu			*/
	point_t		penSize;	/* y̑			*/
	short		*penPat;	/* yp^[			*/
	short		*exPat;		/* gp^[			*/
	short		workKind;	/* VXeŎgp		*/
	void		**workHdl;	/* VXeŎgp		*/
	unsigned short	fgColor;	/* `F			*/
	unsigned short	bgColor;	/* wiF			*/
	short		fontKind;	/* tHg̎		*/
	unsigned short	fontFace;	/* 蕶̎w		*/
	unsigned short	fontMode;	/* `惂[h			*/
	point_t		fontSize;	/* ̑傫			*/
} graph;

typedef	struct pen {
	point_t		loc;		/* `ʒu			*/
	point_t		size;		/* y̑			*/
	unsigned short	mode;		/* `惂[h			*/
	short		*pat;		/* yp^[			*/
} pen;

typedef	char	fontImg[];

typedef	struct fontTbl {
	fontImg	*HA12;			/* PQhbgpAXL[	*/
	fontImg	*ZS12;			/* PQhbgSp		*/
	fontImg	*HA16;			/* PUhbgpAXL[	*/
	fontImg	*HS16;			/* PUhbgpO		*/
	fontImg	*QU16;			/* PUhbgP^SpAXL[	*/
	fontImg	*QL16;			/* PUhbgP^SpAXL[	*/
	fontImg	*QM16;			/* PUhbgP^SpAXL[	*/
	fontImg	*ZA16;			/* PUhbgSp񊿎		*/
	fontImg	*Z116;			/* PUhbgSpP	*/
	fontImg	*Z216;			/* PUhbgSpQ	*/
	fontImg	*ZG16;			/* PUhbgSpO		*/
	fontImg	*ZS16;			/* PUhbgSp		*/
	fontImg	*HA24;			/* QShbgpAXL[	*/
	fontImg	*HG24;			/* QShbgpO		*/
	fontImg	*QU24;			/* QShbgP^SpAXL[	*/
	fontImg	*QL24;			/* QShbgP^SpAXL[	*/
	fontImg	*QM24;			/* QShbgP^SpAXL[	*/
	fontImg	*ZA24;			/* QShbgSp񊿎		*/
	fontImg	*Z124;			/* QShbgSpP	*/
	fontImg	*Z224;			/* QShbgSpQ	*/
	fontImg	*ZG24;			/* QShbgSpO		*/
	fontImg	*ZS24;			/* QShbgSp		*/
} fontTbl;

typedef	struct gProc {			/* `惋[`̃e[u	*/
	int	(*gStr)();		/* ̕`			*/
	int	(*gLine)();		/* C̕`			*/
	int	(*gRect)();		/* N^O̕`		*/
	int	(*gRRect)();		/* EhN^O̕`	*/
	int	(*gOval)();		/* I[o̕`		*/
	int	(*gArc)();		/* A[N̕`			*/
	int	(*gPoly)();		/* |S̕`		*/
	int	(*gRgn)();		/* [W̕`		*/
	int	(*gCopy)();		/* rbgC[W̃Rs[	*/
	void	(*gRsv1)();		/* \				*/
	void	(*gRsv2)();		/* \				*/
	int	(*gStrWidth)();		/* ̕߂		*/
	int	(*gStrLen)();		/* w̕Ɏ܂镶̃oCg߂ */
	void	(*gRsv3)();		/* \				*/
	void	(*gRsv4)();		/* \				*/
	void	(*gRsv5)();		/* \				*/
} gProc;

typedef	struct bits {
	bitmap		bitsBmap;	/* rbg}bv			*/
	point_t		bitsSize;	/* C[W̃oCg		*/
	short		bitsLvl;	/* bNx			*/
	char		bitsRsv[16];	/* \				*/
	unsigned char	bitsData;	/* C[Wf[^		*/
} bits;

typedef	struct fontLink {
	struct fontLink	*flNext;	/* ̃tHgNւ̃|C^ */
	short		flKind;		/* tHghc			*/
	char		*flName;	/* tHg			*/
	int		(*flProc)();	/* tHg[`		*/
	int		*flMem;		/* ubNAhX	*/
	int		flRsv;		/* \				*/
} fontLink;

typedef	struct fontProc {
	int	(*faceJob)();		/* tHgtF[X		*/
	int	(*putCharJob)();	/* `揈			*/
} fontProc;

typedef	struct hProc {
	int	(*hLineInit)();		/* PC`			*/
	int	(*hCopyInit)();		/* PCRs[		*/
	int	(*hPutInit)();		/* PCvbg		*/
} hProc;

typedef	struct hLineRec {
	void	(*hlSub)();		/* `惋[`Gg		*/
	void	(*hlCall0)();		/* Ŏgp			*/
	void	(*hlCall1)();		/* Ŏgp			*/
	void	(*hlCall2)();		/* Ŏgp			*/
	void	(*hlCall3)();		/* Ŏgp			*/
	short	hlPofs;			/* hlPat ̃ItZbg		*/
	short	hlPnext;		/* hlPat PC̃oCg	*/
	short	hlPmask;		/* hlPat ItZbgvZp	*/
	char	hlPat[512];		/* PU~PUhbgp^[	*/
} hLineRec;

typedef	struct hcopyRec {
	void	(*hcSub)();		/* `惋[`Gg		*/
	void	(*hcCall0)();		/* Ŏgp			*/
	void	(*hcCall1)();		/* Ŏgp			*/
	void	(*hcCall2)();		/* Ŏgp			*/
	void	(*hcCall3)();		/* Ŏgp			*/
	short	hcNot0;			/* C[W]f[^		*/
	short	hcNot1;			/* C[W]f[^		*/
	short	hcNot2;			/* C[W]f[^		*/
	short	hcNot3;			/* C[W]f[^		*/
	short	hcSxofs;		/* Ŏgp			*/
	short	hcDxofs;		/* Ŏgp			*/
	int	hcSpage;		/* Ŏgp			*/
	int	hcDpage;		/* Ŏgp			*/
	short	hcRev;			/* E獶ɃRs[tO	*/
} hCopyRec;

typedef	struct rgnProc {
	void	(*andRgnLine)();	/* sƍŝ`mc߂	*/
	void	(*orRgnLine)();		/* sƍŝnq߂		*/
	void	(*diffRgnLine)();	/* sƍs̍߂		*/
	void	(*xorRgnLine)();	/* sƍŝwnq߂	*/
} rgnProc;
/*
 *	XN[JCh
 */
#define	G_TXT		0
#define	G_GRP		1
#define	G_GR2		2
#define	G_GR3		3
/*
 *	h[[h
 */
#define	G_PSET		0
#define	G_AND		1
#define	G_OR		2
#define	G_XOR		3
#define	G_NPSET		4
#define	G_NAND		5
#define	G_NOR		6
#define	G_NXOR		7
#define	G_ADD		8
#define	G_ADDLIM	9
#define	G_SUB		10
#define	G_SUBLIM	11
#define	G_SELMAX	12
#define	G_SELMIN	13
#define	G_BLEND		14
/*
 *	y[h
 */
#define	G_FORE		0x000
#define	G_BACK		0x100
#define	G_PPAT		0x200
#define	G_EPAT		0x300
/*
 *	tHgJCh
 */
#define	G_ROM12		0
#define	G_ROM16		1
#define	G_ROM24		2
/*
 *	tHgtF[X
 */
#define	G_PLANE		0
#define	G_BOLD		1
#define	G_ITALIC	2
#define	G_ULINE		4
#define	G_OLINE		8
#define	G_SHADOW	16
/*
 *	tHgtF[Xrbgԍ
 */
#define	GB_BOLD		0
#define	GB_ITALIC	1
#define	GB_ULINE	2
#define	GB_OLINE	3
#define	GB_SHADOW	4
/*
 *	vbg[h
 */
#define	G_STD		0
#define	G_REV		1
#define	G_HILITE	2
#define	G_HILREV	3
#define	G_ERACE		4

#define	G_MESH		6
#define	G_MESREV	7
#define	G_HIDDEN	8
#define	G_HIDREV	9
/*
 *	eLXgJ[
 */
#define	G_THRU		0		/* 		*/
#define	G_WHITE		8		/* 		*/
#define	G_LGRAY		9		/* 邢O[	*/
#define	G_DGRAY		10		/* ÂO[	*/
#define	G_BLACK		11		/* 		*/
#define	G_YELLOW	12		/* F		*/
#define	G_RED		13		/* 		*/
#define	G_GREEN		14		/* 		*/
#define	G_BLUE		15		/* 		*/
/*
 *	OtXNvgR}h
 */
#define	GS_NOP		0
#define	GS_REM		1
#define	GS_BITMAP	2
#define	GS_APAGE	3
#define	GS_CLIP		4
#define	GS_PMODE	5
#define	GS_PSIZE	6
#define	GS_FKIND	7
#define	GS_FFACE	8
#define	GS_FMODE	9
#define	GS_FSIZE	10
#define	GS_FORE		11
#define	GS_BACK		12
#define	GS_PPAT		13
#define	GS_EXPAT	14
#define	GS_LINE		15
#define	GS_FRRECT	16
#define	GS_FLRECT	17
#define	GS_FRRRECT	18
#define	GS_FLRRECT	19
#define	GS_FROVAL	20
#define	GS_FLOVAL	21
#define	GS_FRARC	22
#define	GS_FLARC	23
#define	GS_FRPOLY	24
#define	GS_FLPOLY	25
#define	GS_FRRGN	26
#define	GS_FLRGN	27
#define	GS_STR		28
#define	GS_PUT		29
#define	GS_COPY		30
#define	GS_END		-1
/*
 *	tHgvZXR}h
 */
#define	FP_INIT		0
#define	FP_TINI		1
#define	FP_INFO		2
#define	FP_DRAW		3
#define	FP_LENGTH	4
#define	FP_WIDTH	5
#define	FP_REV		6
#define	FP_RSV		7

#define	FP_MAX		7

/************************************************/
/*	EBhE} (Window Man)		*/
/************************************************/

typedef	struct window {
	graph		wGraph;		/* Ot}̕`XgN` */
	unsigned short	wKind;		/* EBhE̎		*/
	char		wVisible;	/* `			*/
	char		wHilite;	/* ANeBu		*/
	char		wClose;		/* N[Y{bNX		*/
	char		wStatus;	/* EBh}Ŏgp	*/
	unsigned short	wOption;	/* EBhEACe̎w	*/
	region		**wOutside;	/* EBhE̊Og̈	*/
	region		**wInside;	/* EBhE̓̈	*/
	region		**wUpdate;	/* EBhȄ̈ */
	long		(**wDef)();	/* EBhE`֐ւ̃nh */
	long		wDefData;	/* EBhE`֐̃f[^	*/
	LASCII		**wTitle;	/* EBhE^Cgւ̃nh */
	unsigned short	wTWidth;	/* EBhE^Cg̕	*/
	long		wControl;	/* Rg[ւ̃nh	*/
	struct window	*wNext;		/* ̃EBhEւ̃|C^	*/
	gScript		**wGScript;	/* Abvf[gpOtXNvg */
	long		wTask;		/* rwVFp^XNhc	*/
} window;

typedef	struct WIND {
	rect	rwBounds;
	short	rwDefID;
	short	rwVisible;
	short	rwCBox;
	long	rwTaskID;
	LASCII	rwTitle;
} WIND;

typedef struct zoom {
	rect	stdRect;
	rect	exdRect;
} zoom;

/*
 *	EBhEp[gR[h
 */
#define	W_INDESK	0
#define	W_ININSIDE	3
#define	W_INDRAG	4
#define	W_INGROW	6
#define	W_INCLOSE	7
#define	W_INZMOUT	8
#define	W_INZMIN	9
#define	W_INARROW	13
#define	W_INCLPON	14
#define	W_INCLPOFF	15
#define	W_INDRIVE	16
/*
 *	wKind
 */
#define	WK_DIALOG	2
#define	WK_USER		8
#define	WK_GRAPHIC	16		/* window with graphics */
#define	WK_SUB		32
/*
 *	EBhE`֐R}h
 */
#define	CMD_WDRAW	0
#define	CMD_WWHERE	1
#define	CMD_WCALC	2
#define	CMD_WNEW	3
#define	CMD_WDISP	4
#define	CMD_WGROW	5
#define	CMD_WGBOX	6
#define	CMD_WFILL	7
#define	CMD_WMOVE	8
/*
 *	\[X 'WIND' hc
 */
#define	WI_STD		32	/* WEBhE			*/
#define	WI_STD2		49	/* WEBhEiN[Y{bNX̂݁j*/
#define	WI_PLN		36	/* v[EBhE			*/
#define	WI_STDG		48	/* WEBhEiOtBbNT|[gj*/
#define	WI_STDG2	50	/* WEBhEiOtBbNT|[gAN[Y{bNX̂݁j*/
/*
 *	IvVR[h
 */
#define	WC_SCROLL	1
#define	WC_CLIP		2
#define	WC_DRIVE	4
#define	WC_GBOX		8
/*
 *	wOption }XN
 */
#define	WC_GBOXON	0x0100
#define	WC_ARROW	0x0200
#define	WC_CLIPON	0x8000
/*
 *	wOption rbgԍ
 */
#define	WCB_SCROLL	0
#define	WCB_CLIP	1
#define	WCB_DRIVE	2
#define	WCB_GBOX	3
#define	WCB_GBOXON	8
#define	WCB_ARROW	9

/************************************************/
/*	TuEBhE}iSub Window manj	*/
/************************************************/

typedef	struct subWindow {
	window	tWin;
	long	tPrio;
} subWindow;

/************************************************/
/*	j[} (Menu Man)			*/
/************************************************/

typedef	struct mItem {
	char	mSKey;			/* V[gJbgR[hi'A'`'Z'j*/
	char	mCheck;			/* `FbN}[Nt	*/
	LASCII	mTitle;			/* \			*/
} mItem;

typedef	struct mIList	{
	short	mILSize;		/* ACě|P		*/
	mItem	mILData;
} mIList;

typedef	struct menu	{
	short		mID;		/* \[X 'MDEF' ̂hcł	*/
	short		mWidth;		/* j[}ŊǗ܂ */
	short		mHight;		/* j[}ŊǗ܂ */
	int		mProc;		/* j[`֐ւ̃nh	*/
	unsigned	mEnable;	/* j[ACe̎gptO */
	long		mHandle;	/* j[`֐̃f[^	*/
	mIList		mData;		/* j[ACeXgf[^	*/
} menu;
/*
 *	j[`֐R}h
 */
#define	CMD_MDRAW	0
#define	CMD_MSEL	1
#define	CMD_MCALC	2
#define	CMD_MINIT	4
#define	CMD_MDISP	5
#define	CMD_MCHCK	6

/************************************************/
/*	Rg[} (Control Man)		*/
/************************************************/

typedef	struct control {
	struct control	*cNext;		/* ̃Rg[ւ̃nh	*/
	window		*cWindow;	/* EBhEւ̃|C^ */
	rect		cRect;		/* ̑傫lp`	*/
	char		cVisible;	/* ^s		*/
	char		cHilite;	/* \^gps		*/
	short		cValue;		/* ݒl			*/
	short		cMin;		/* ŏl			*/
	short		cMax;		/* ől			*/
	int		(*cDef)();	/* Rg[`֐ւ̃nh */
	unsigned short	cOption;	/* Rg[̃IvV	*/
	long		cDefData;	/* `֐̃f[^		*/
	void		(*cProc)();	/* hbNɌĂяo葱 */
	long		cUser;		/* [U[p̃[NGA	*/
	LASCII		cTitle;		/* Rg[^Cg		*/
} control;

typedef	struct CTRL {
	rect	rcBounds;
	short	cValue;
	short	rcVisible;
	short	rcMax;
	short	rcMin;
	short	rcID;
	long	rcUser;
	LASCII	rcTitle;
} CTRL;
/*
 *	Rg[`֐R}h
 */
#define	CMD_CDRAW	0
#define	CMD_CWHERE	1
#define	CMD_CCALC	2
#define	CMD_CINIT	3
#define	CMD_CDISP	4
#define	CMD_CPOS	5
#define	CMD_CTHUMB	6
#define	CMD_CDRAG	7
#define	CMD_CTRACK	8
/*
 *	Rg[p[gR[h
 */
#define	C_INBTTN	10
#define	C_INCHECK	11
#define	C_INUP		20
#define	C_INDOWN	21
#define	C_INPGUP	22
#define	C_INPGDOWN	23
#define	C_INTITLE	24
#define	C_INTHUMB	129
/*
 *	CDEF ID
 */
#define	CI_STDBTN	0	/* W{^				*/
#define	CI_SELBTN	1	/* ZNg{^			*/
#define	CI_OTNBTN	2	/* I^[lCg{^			*/
#define	CI_SLDVOL	19	/* XCh{[			*/
#define	CI_SLDBTN	20	/* Abv_E{^			*/
#define	CI_SCLBRWH	64	/* XN[o[iAEBhEpj	*/
#define	CI_SCLBRWV	65	/* XN[o[icAEBhEpj	*/
#define	CI_SCRLBRH	66	/* XN[o[ij			*/
#define	CI_SCRLBRV	67	/* XN[o[icj			*/

/************************************************/
/*	eLXg} (Text Man)			*/
/************************************************/

typedef	struct tEdit {		/* eLXgGfBbgR[h		*/
	rect	dest;		/* fBXeBl[VN^O	*/
	rect	view;		/* r[N^O			*/
	long	offsetH;	/* ␳W			*/
	long	offsetV;	/* ␳W			*/
	char	**HText;	/* ҏWւ̃nh		*/
	int	lenMax;		/* ҏWeLXg͍̓ő吔		*/
	int	length;		/* ɓ͂ĂҏWeLXg̒	*/
	int	rsv0;		/* VXe\				*/
	int	selStart;	/* ZNg͈͂̊Jnʒu		*/
	int	selEnd;		/* ZNg͈͂̏Iʒu		*/
	int	selLine;	/* ݂̃ZNgsʒu			*/
	int	selOffset;	/* ݂̃obt@̃ZNgʒu		*/
	int	refCon;		/* [U[`f[^			*/
	short	lineHeight;	/* s				*/
	short	tabSize;	/* ^uTCY				*/
	short	just;		/* s	@OF
						@PF
						|PFE		*/
	char	drawMode;	/* ҏW[h
					rbgOFsR[h\
					rbgPF"EOF" \
					rbgQFꕶ\
					rbgRFRg[R[h
					rbgSFҏWs
					rbgTF낦		*/
	char	visible;	/* Oȏŕ\			*/
	long	locateH;	/* WOl			*/
	long	locateV;	/* WOl			*/
	graph	*InPort;	/* Otւ̃|C^			*/
	int	caretTime;	/* Ŏgp				*/
	short	caretState;	/* Ŏgp				*/
	int	(*(*procs))();	/* vZXe[uւ̃|C^		*/
	short	*funcCode;	/* t@NVL[ATCe[uւ̃|C^ */
	short	*ctrlCode;	/* Rg[L[e[uւ̃|C^	*/
	int	(*(*cprocs))();	/* Rg[L[[`e[uւ̃|C^ */
	int	nColumns;	/* eLXg̒iisR[h܂łPij*/
	int	nLines;		/* eLXg̍si܂Ȃ鏊܂łPsj*/
	int	**lineStarts;	/* VXegp			*/
} tEdit;

typedef	struct teHis {		/* ҏW				*/
	short	editon;		/* OȊOŕҏWꂽ			*/
	int	editnLine;	/* ҏWs				*/
	int	editStart;	/* ҏWJnoCgʒu			*/
	int	editLine;	/* ҏWJnsʒu			*/
	int	editLocateH;	/* ҏWJnW			*/
	int	editLocateV;	/* ҏWJnW			*/
	int	editLocateM;	/* ҏWJnWCl			*/
	int	editCoLine;	/* ̒i̐擪sʒu			*/
	int	editCoDiff;	/* OȊOŎ̒iXN[	*/
} teHis;

typedef	struct teColumn {	/* i				*/
	int	coPos;		/* iʒu				*/
	int	coLcnt;		/* i̍s				*/
	int	coLine;		/* i̐擪sʒu			*/
	int	coOffset;	/* i̐擪s̃ItZbg		*/
	int	coSize;		/* ĩoCg			*/
	int	coPtr;		/* iւ̃|C^			*/
	int	line;		/* sʒu				*/
	int	lineOffset;	/* s̐擪ʒuItZbg		*/
	int	lineSize;	/* s̃oCg				*/
	int	linePtr;	/* sւ̃|C^			*/
} teColumn;

/************************************************/
/*	_CAO} (Dialog Man)		*/
/************************************************/

typedef	struct dlgItem {		/* [hEɑ邱	*/
	long		dlgIHdl;	/* Rg[ւ̃nh	*/
	rect		dlgIBounds;	/* _CAOACe̋Elp` */
	unsigned char	dlgIType;	/* _CAOACe̎	*/
	unsigned char	dlgISize;	/* _CAOACȅlf[^TCYiO`QTTj*/
	unsigned short	dlgIData;	/* _CAOACȅlf[^ */
} dlgItem;

typedef	struct dlgIList {
	short		dlgILSize;	/* _CAOACě|P	*/
	short		dlgILData;	/* ŏ̃_CAOACeɂ */
} dlgIList;

typedef	struct dialog {
	window		dWindow;	/* _CAOEBhE		*/
	dlgIList	**dItems;	/* _CAÕACeXgւ̃nh */
	tEdit		**dText;	/* eLXgGfBbgւ̃nh */
	short		dTMan;		/* Ŏgp			*/
	short		dTMOpen;	/* Ŏgp			*/
	short		dReserve;	/* \				*/
} dialog;

typedef	struct DLOG {
	rect		rdBounds;
	short		rdWID;
	short		rdVisible;
	short		rdCBox;
	long		rdTask;
	short		rdItems;
	LASCII		rdTitle;
} DLOG;
/*
 *	_CAOACe^Cv
 */
#define	DT_USER		0		/* [U[ACe		*/
#define	DT_STDBTN	4		/* W{^			*/
#define	DT_SELBTN	5		/* ZNg{^		*/
#define	DT_OTNBTN	6		/* I^[lCg{^		*/
#define	DT_RSCITM	7		/* XN[o[Ȃ		*/
#define	DT_STCTXT	8		/* ҏWs\eLXg		*/
#define	DT_EDTTXT	16		/* ҏW\eLXgieLXg}gpj*/
#define	DT_ICNITM	32		/* ACR			*/
#define	DT_PICITM	64		/* OtXNvg		*/
#define	DT_DISABL	128		/* Aґ			*/
/*
 *	_CAOACe^Cvrbgԍ
 */
#define	DB_CTLITM	2
#define	DB_STCTXT	3
#define	DB_EDTTXT	4
#define	DB_ICNITM	5
#define	DB_PICITM	6
#define	DB_DISABL	7

/************************************************/
/*	^XN} (Task Man)			*/
/************************************************/

typedef	struct cell {			/* ZR[h			*/
	unsigned long	kind;		/* f[^̎ނ\AXL[S */
	long		length;		/* ȍ~̃TCY		*/
	unsigned char	data[2];	/* length ̃f[^		*/
} cell;

typedef	struct tsevent {		/* ^XN}CxgR[h	*/
	short	what;			/* Cxg̎ށiapp1evnt, app2evntj*/
	long	whom;			/* P			*/
	long	when;			/* `bNJEg		*/
	long	whom2;			/* Q			*/
	short	what2;			/* ^XN}̃Cxg̎	*/
	short	tskid;			/* ̃^XNhc		*/
} tsevent;

typedef	struct drinfo {			/* hCu񃌃R[h		*/
	unsigned char	mediabyte;	/* fBAoCg		*/
	unsigned char	unitno;		/* jbgmn			*/
	short		driveno;	/* hCuԍ			*/
} drinfo;

typedef	struct drag {			/* hbOR[h		*/
	long	length;			/* ZXg̒		*/
	void	**cellHdl;		/* ZXgւ̃nh	*/
	short	tskid;			/* ̃^XNhc		*/
	point_t	origen;			/* [JW̃ItZbg	*/
	long	imagePtr;		/* C[Wf[^ւ̃|C^	*/
} drag;

typedef	struct scrap {			/* XNbvR[h		*/
	long	length;			/* ZXg̒		*/
	void	**cellHdl;		/* ZXgւ̃nh	*/
} scrap;

typedef	struct task {		/* ^XNǗe[u			*/
	char	name[90];	/* ^XN				*/
	LASCII	command;	/* R}hC			*/
	short	tskid;		/* ̃^XNhc			*/
	short	parentid;	/* ẽ^XNhc			*/
	short	stmode;		/* グ[h			*/
	long	rsctype;	/* \[X^Cv			*/
	short	rscid;		/* \[Xhc				*/
	short	state;		/* ݂̏				*/
	long	*programPtr;	/* vOGÃ|C^		*/
	long	**programHdl;	/* vOGÃnh		*/
	long	**dataHdl;	/* f[^GÃnh		*/
	char	*envPtr;	/* GAւ̃|C^		*/
	long	regkeep[18];	/* d0-d7/a0-a7/sr/usp/pc ޔp		*/
	short	commsendid;	/* ŌɑM^XN̂hc		*/
	short	commrecvid;	/* ݎ󂯂Ă^XNԒʐM̑M^XN̂hc */
	long	tickcount;	/* Ñ`bNJEg		*/
	long	commonHdl;	/* S^XNʃf[^ւ̃nh	*/
	short	rsv[26];	/* VXe\				*/
} task;

typedef	struct builtin {	/* rgCR}h`R[h	*/
	short	rscid;		/* 'CODE' ̂hc			*/
	char	name[1+90];	/* R}hiO`XOoCgϒj	*/
} builtin;

typedef	struct icstate {		/* ACRǗR[h		*/
	rect		image;		/* Ŝ͂ގlp`i[JWj*/
	char		name[18+3];	/* O				*/
	unsigned char	attr;		/* 				*/
	long		opt1;		/* IvVP			*/
	long		opt2;		/* IvVQ			*/
	unsigned char	mediabyte;	/* fBAoCg		*/
	unsigned char	unitno;		/* jbgԍ			*/
	short		iconid;		/* 'ICN#' ̂hcԍ		*/
	char		*pathPtr;	/* pXi[AhX		*/
	unsigned char	bitflag;	/* tĩtOiveNgACWFNgj*/
	unsigned char	drawMode;	/* \[h			*/
/*	unsigned char	rsv[4];	*/	/* VXegp		*/
	unsigned char   isSelflag;
	unsigned char   isOpenflag;
	unsigned char isDragflag;
	unsigned char isPlace;
} icstate;

typedef	struct ickind {		/* ACR`R[hi\[X^Cv 'ICN#'j*/
	long	type;		/* rbgf[^̃\[X^Cv		*/
	short	id;		/* rbgf[^̂hc			*/
	short	attrib;
	short	mldown;
	short	menuid1;
	short	menuid2;
	char	name[1+90];	/* OiO`XOoCgϒj		*/
	char	execf[1+90];	/* st@CiO`XOoCgϒj*/
	char	param[1+255];	/* p[^iO`QTToCgϒj	*/
} ickind;

typedef	struct openfile {	/* I[vt@CǗR[h	*/
	char	name[90];	/* t@C				*/
	short	mode;		/* ANZX[h			*/
	short	id;		/* t@Cnh			*/
} openfile;
/*
 * ^XNǗe[u state ڍ
 */
#define	EMPTY		0	/* 폜R[h				*/
#define	ACTIVE		1	/* ʏ퓮쒆				*/
#define	COMMUNICATE	2	/* ^XNԒʐMiԎ󂯂j	*/
#define	SENDMES		3	/* ^XNԒʐMiԎ󂯂Ȃj	*/
#define	SLEEP		4	/* VXe\				*/
#define	STARTUP		5	/* N				*/
#define	LOAD		6	/* [h			*/
#define	EXIT		7	/* ݒI				*/
/*
 * rgCR}hVXe\iCMDS ̂hcj
 */
#define	CMDSDIR		0	/* fBNg\			*/
#define	CMDSCHD		1	/* hCugC			*/
#define	CMDSPINFO	2	/* vZX				*/
#define	CMDSDINFO	3	/* hCu				*/
#define	CMDSINFO	4	/* t@C				*/
#define	CMDSCLO		5	/* pX̃N[Y			*/
#define	CMDSREN		6	/* t@C̕ύXAȂ	*/
#define	CMDSCLIP	7	/* Nbv{[h			*/
#define	CMDSVDCP	8	/* fBXNRs[			*/
#define	CMDSVFOR	9	/* tH[}bg				*/
#define	CMDSCOPY	10	/* t@C̃Rs[			*/
#define	CMDSCSHL	11	/* R}h				*/
#define	CMDSHENW	12	/* ZbgɋNt@C		*/
#define	CMDSTITL	13	/* IɋNt@C		*/
/*
 * ^XN}Cxgꗗ
 */
#define	ENDTSK		1	/* ^XN̏I				*/
#define	CLOSEALL	2	/* SEChẼN[Y		*/
#define	NOTICEEJECT	3	/* fBXNCWFNg̗\		*/
#define	DISKEJECT	4	/* fBXÑCWFNg			*/
#define	NOTICEFORMAT	5	/* fBXNtH[}bg̗\		*/
#define	DISKFORMAT	6	/* fBXÑtH[}bg		*/
#define	NOTICEDCOPY	7	/* fBXNRs[̗\			*/
#define	DISKCOPY	8	/* fBXÑRs[			*/
#define	DISKINSERT	9	/* fBXN̑}܂͏Ԃ̕ω	*/
#define	RMDIR		10	/* fBNg̍폜			*/
#define	DELETEFILE	11	/* t@C̍폜			*/
#define	DELETEVONAME	12	/* {[̍폜			*/
#define	MOVEFILE	13	/* t@C̈ړ			*/
#define	COPYFILE	14	/* t@C̕			*/
#define	MKDIR		15	/* fBNg̍쐬			*/
#define	CREATFILE	16	/* t@C̍쐬			*/
#define	CREATEVONAME	17	/* {[̍쐬			*/
#define	OPENFILE	20	/* t@C̃I[v			*/
#define	CLOSEFILE	21	/* t@C̃N[Y			*/
#define	CHMODFILE	22	/* t@C̕ύX			*/
#define	CLOSE		30	/* w肵pX̃N[Y		*/
#define	SAVE		31	/* ݂̏ԂZ[u			*/
#define	WINDOWSELECT	32	/* EChẼZNg			*/
#define	NOTICEENDTSK	33	/* ^XN̏I̗\			*/
#define	TOSCRAP		50	/* XNbvobt@ւ̃f[^]	*/
#define	EMPTYTRASH	51	/* ݔ̃tbV			*/
#define	DRAGNOW		80	/* hbO				*/
#define	DRAGEND		81	/* hbOI				*/
#define	CHANGEDRSC	90	/* \[X̕ύX			*/
#define	REQLOADRSC	104	/* \[X̃ւ̓ǂݍݗv	*/
#define	RESLOADRSC	105	/* \[X̃ւ̓ǂݍݗvɑ΂G[̕ԑ */
#define	FOCKCHD		62	/* JgfBNgw肵ċN */
#define	FOCKALL		63	/* t@C̋N			*/
#define	FOCKCELL	64	/* ZXg̋N			*/
#define	FOCKNOTHEAD	65	/* VFœ삵Ȃt@C̋N	*/
/*
 * ^XN}G[R[h
 */
#define	ER_ABORT	-8194	/* cnrR[ŃA{[g		*/
#define	ER_OBJX		-8193	/* PƎs̃t@C			*/
#define	ER_NOTHEAD	-8192	/* ^XN}œ삵Ȃt@C	*/
#define	ER_NOTOBJECT	-8191	/* st@Cł͂Ȃ			*/
#define	ER_NOTLOAD	-8190	/* t@CI[vG[		*/
#define	ER_NOTPARA	-8189	/* ɕsłȂt@C	*/
#define	ER_FILENOTFND	-8161	/* t@CȂ		*/
#define	ER_SERCHBREAK	-8160	/* t@Cfꂽ		*/

/************************************************/
/*	vg}(Print Man)			*/
/************************************************/

typedef	struct prRec {			/* paper			*/
	short	prPaperKind;		/* p̎			*/
	short	prPaperOption;		/* IvVLE		*/
	rect	prPaperRect;		/* p̃hbg̃N^Oip͕j*/
	rect	prLimitRect;		/* 󎚉\ȃhbg̃N^Oip͕j*/
	rect	prPageRect;		/* ۂɈ󎚂s̈ip (0,0)j*/
	char	prPaperRsv[ 8 ];	/* gp			*/
					/* document			*/
	short	prDocImage;		/* rbgC[Wŏo͂	*/
	short	prDocColumn;		/* Ps			*/
	short	prDocLine;		/* Py[Ws			*/
	short	prDocTab;		/* ^uTCY			*/
	short	prDocHeight;		/* sihbgj		*/
	char	prDocRsv[ 8 ];		/* gp			*/
					/* printer			*/
	point_t	prRes;			/* 󎚉𑜓xihbg^C`j	*/
	point_t	prANKSize;		/* pTCYihbgj	*/
	point_t	prKanjiSize;		/* SpTCYihbgj	*/
	short	prColorKind;		/* J[󎚂̐F		*/
	char	prPrnRsv[ 8 ];		/* VXe\			*/
					/* maneger			*/
	short	prManVer;		/* }l[W̃o[W	*/
	char	prManRsv[ 8 ];		/* v^}l[Wp		*/
					/* driver			*/
	short	prDrvVer;		/* hCõo[W		*/
	char	prDrvRsv[ 8 ];		/* v^hCop		*/
					/* user				*/
	short	prMinPage;		/* ͈͊Jny[WiAvP[VZbgj*/
	short	prMaxPage;		/* ͈͏Iy[WiAvP[VZbgj*/
	long	prUserData;		/* J[e[uւ̃nh	*/
	char	prUserRsv[ 8 ];		/* \				*/
					/* job				*/
	short	prFstPage;		/* Jny[W		*/
	short	prLstPage;		/* Iy[W		*/
	short	prDupPage;		/* Py[Ẅ	*/
	short	prMode;			/* [hihtgAJ[j*/
	short	prMask;			/* [h̃}XN		*/
	char	prJobRsv[ 8 ];		/* gp			*/
					/* work				*/
	short	prPageCount;		/* ݈̃y[W		*/
	short	prDupCount;		/* ݈̕		*/
	char	prWorkRsv[ 8 ];		/* \				*/
} prRec;

typedef	struct prtDrvr {
	long	pType;		/* 'OBJR' Œ				*/
	long	pcSize;		/* R[ḧ̃TCY			*/
	long	pExec;		/* rwX^[gAhXItZbgi_~[j*/
	long	pdSize;		/* vOf[^TCY		*/
	long	pRsv[ 3 ];	/* \					*/
	long	prtDrvrName;	/* v^̃ItZbg		*/
	long	prtDrvrStart;	/* hCoX^[gAhXItZbg	*/
	long	prtDrvrType;	/* 'PRTD'				*/
	short	prtDrvrVer;	/* $0100 ̂悤Ƀo[W	*/
	short	prtDrvrExt;	/* gp				*/
} prtDrvr;

typedef	struct prtdInfo {
	short	prtdID;			/* hc			*/
	short	prtdVer;		/* o[W		*/
	char	prtdName[ 40 ];		/* OiASCIIZj	*/
} prtdInfo;
/*
 *	prPaperKind
 */
#define	P_FREE		0
#define	P_A3		1
#define	P_A3R		2
#define	P_A4		3
#define	P_A4R		4
#define	P_A5		5
#define	P_A5R		6
#define	P_B3		7
#define	P_B3R		8
#define	P_B4		9
#define	P_B4R		10
#define	P_B5		11
#define	P_B5R		12
#define	P_10x11		13
#define	P_15x11		14
#define	P_LETTER	15
#define	P_LETTERR	16
/*
 *	prPaperOption
 */
#define	P_NONE		0
#define	P_TRACTOR	1
#define	P_CUTSHEET	2
#define	P_LETSHEET	3
/*
 *	prDocImage
 */
#define	P_GAIJI		1
#define	P_RSV		2
#define	P_KANJI2	4
#define	P_KANJI1	8
#define	P_ANK		16

#define	PB_GAIJI	0
#define	PB_RSV		1
#define	PB_KANJI2	2
#define	PB_KANJI1	3
#define	PB_ANK		4
/*
 *	prMode, prMask
 */
#define	P_DRAFT		1
#define	P_COLOR		2

#define	PB_DRAFT	0
#define	PB_COLOR	1
/*
 *	Rg[
 */
#define	PC_STAT		0
#define	PC_END		1
#define	PC_STOP		2
#define	PC_CONT		3
/*
 *	Xe[^X
 */
#define	P_FINISH	0
#define	P_WORKING	1
#define	P_RESTING	2
#define	P_TIMEOUT	3
#define	P_ERROR		-1
/*
 *	v^Rg[R}h
 */
#define	PD_RESET	0
#define	PD_CRLF		1
#define	PD_FF		2
#define	PD_STRING	3
#define	PD_BITIMAGE	4
#define	PD_GSCRIPT	5


/* Method SX ver 0.2 */
/* 93-08-02          */


#define		M_RSCBIT	(0x2)
#define		M_PURGEBIT	(0x8)
#define		M_LOCKBIT	(0x10)
typedef	struct {
	long	Hpos;		/* W	*/
	long	Vpos;		/* W	*/
	long	adjust;		/* sׂ̈̕␳l	*/
} tPosInfo;

typedef	struct {
	long	Hoffset;	/* WItZbg	*/
	long	Voffset;	/* WItZbg	*/
} tOffset;

typedef	struct {
	long	Start;		/* ZNgJnʒu	*/
	long	End;		/* ZNgIʒu	*/
	long	NowPos;		/* ݂̃ZNgʒu	*/
} tSelectInfo;

typedef	union {
	struct {
		unsigned char Hmode1;	/* nh[hP */
		unsigned char Hmode2;	/* nh[hQ */
	} Mode;
	short	mode;
} UnionMode;
