/*
 * sxlib.h X68k XC Compiler v2.00 Copyright 1990 SHARP/First Class Technology
 * sxlib.h for SX gcc modify by Mariko
 */

#ifndef __SXLIB_H
#define  __SXLIB_H
#include <sxdef.h>
#ifndef __SX_GCC__
#error
#else
/************************************************/
/*	} (Memory Man)			*/
/************************************************/

SXCALL	long	MMInitHeap(struct hoe *);
SXCALL	long	MMGetCurrentHeap(void);				/* _SXCALLPtr */
SXCALL	long	MMSetCurrentHeap(Heap *);
#ifndef	__MEMCHECK
SXCALL	long	MMNewHandle(long);				/* _SXCALLPtr */
#else
	long	MMNewHandle(long);					/* _SXCALLPtr */
#endif
SXCALL	long	MMSetHandleSize(handle, long);			/* _SXCALLPtr */
#ifndef	__MEMCHECK
SXCALL	long	MMDisposeHandle(handle);			/* _SXCALLPtr */
#else
	long	MMDisposeHandle(handle);			/* _SXCALLPtr */
#endif
SXCALL	long	MMGetHandleSize(handle);			/* _SXCALLPtr */
SXCALL	long	MMHLock(handle);				/* _SXCALLPtr */
SXCALL	long	MMHUnlock(handle);				/* _SXCALLPtr */
#ifndef __MEMCHECK
SXCALL	long	MMNewPtr(long);					/* _SXCALLPtr */
#else
	long	MMNewPtr(long);					/* _SXCALLPtr */
#endif
#ifndef __MEMCHECK
SXCALL	long	MMDisposePtr(pointer);				/* _SXCALLPtr */
#else
	long	MMDisposePtr(pointer);				/* _SXCALLPtr */
#endif
SXCALL	long	MMGetPtrSize(pointer);				/* _SXCALLPtr */
SXCALL	long	MMSetPtrSize(pointer, long);			/* _SXCALLPtr */
SXCALL	long	MMCompactMem(long);				/* _SXCALLPtr  */
SXCALL	Heap	*MMHeapInit(void *, void *, short, int (*)(), long);
SXCALL	Master	*MMBlockMstGet(Heap *, Block);
SXCALL	Block	*MMMemCompact(Heap *, long);
SXCALL	Block	*MMMemPurge(Heap *, long);
SXCALL	Block	*MMMemMelt(Heap *, long);
SXCALL	Block	*MMMemReserve(Heap *, long);
SXCALL	long	MMMemSizeFree(Heap *);
SXCALL	long	MMMemSizeComp(Heap *);
SXCALL	long	MMMemSizePurge(Heap *);
SXCALL	long	MMMemSizeMelt(Heap *);
SXCALL	long	MMMemErrorGet(void);
SXCALL	long	MMMemErrorSet(long);
SXCALL	long	MMMemStrictGet(void);
SXCALL	long	MMMemStrictSet(long);
SXCALL	Heap	*MMChGet(void);
SXCALL	long	MMChSet(Heap *);

#ifndef	__MEMCHECK
SXCALL	pointer	MMChPtrNew(long);
#else
	pointer	MMChPtrNew(long);
#endif
SXCALL	long	MMChMstMore(void);
SXCALL	Master	*MMChMstNew(void);
#ifndef	__MEMCHECK
SXCALL	handle	MMChHdlNew(long);
#else
	handle	MMChHdlNew(long);
#endif
SXCALL	Block	*MMChCompact(long);
SXCALL	Block	*MMChPurge(long);
SXCALL	Block	*MMChMelt(long);
SXCALL	Block	*MMChReserve(long);
SXCALL	long	MMChFreeSize(void);
SXCALL	long	MMChGrowHeapGet(void);
SXCALL	long	MMChGrowHeapSet(int (*)());
SXCALL	long	MMChPurgeGet(void);
SXCALL	long	MMChPurgeSet(int (*)());
SXCALL	long	MMChCompactGet(void);
SXCALL	long	MMChCompactSet(int (*)());
SXCALL	pointer	MMPtrNew(Heap *, long);
SXCALL	Heap	*MMPtrHeap(pointer);
#ifndef	__MEMCHECK
SXCALL	long	MMPtrDispose(pointer);
#else
	long	MMPtrDispose(pointer);
#endif
SXCALL	long	MMPtrSizeGet(pointer);
SXCALL	long	MMPtrSizeSet(pointer, long);
SXCALL	long	MMPtrPropGet(pointer);
SXCALL	long	MMPtrPropSet(pointer, long);
SXCALL	long	MMMstAllocate(Heap *);
SXCALL	Master	*MMMstBind(Heap *);
SXCALL	handle	MMHdlNew(Heap *, long);
SXCALL	Heap	*MMHdlHeap(handle);
#ifndef	__MEMCHECK
SXCALL	long	MMHdlDispose(handle);
#else
	long	MMHdlDispose(handle);
#endif
SXCALL	long	MMHdlSizeGet(handle);
SXCALL	long	MMHdlSizeSet(handle, long);
SXCALL	long	MMHdlEmpty(handle);
SXCALL	long	MMHdlRealloc(handle, long);
SXCALL	long	MMHdlMoveHi(handle);
SXCALL	long	MMHdlPropGet(handle);
SXCALL	long	MMHdlPropSet(handle, int);
SXCALL	long	MMHdlLock(handle);
SXCALL	long	MMHdlUnlock(handle);
SXCALL	long	MMHdlPurge(handle);
SXCALL	long	MMHdlNoPurge(handle);
SXCALL	long	MMHdlResource(handle);
SXCALL	long	MMHdlNoResource(handle);
SXCALL	long	MMHdlIns(handle, long, long);
SXCALL	long	MMHdlDel(handle, long, long);
SXCALL	long	MMBlockUsrFlagGet(Block *);
SXCALL	long	MMBlockUsrFlagSet(Block *, long);
SXCALL	long	MMBlockUsrWordGet(Block *);
SXCALL	long	MMBlockUsrWordSet(Block *, long);
SXCALL	void	MMMemAmiTPeach(Heap *, int (*)(), int (*)());
SXCALL	Block	*MMMemHiReserve(Heap *, long);
SXCALL	Block	*MMPtrBlock(pointer);
SXCALL	Block	*MMHdlBlock(handle);
SXCALL	handle	MMHdlMstGet(Heap *, pointer);
SXCALL	Block	*MMChHiReserve(long);
SXCALL	long	MMChUsrFlagGet(void);
SXCALL	long	MMChUsrFlagSet(long);
SXCALL	long	MMChUsrWordGet(void);
SXCALL	long	MMChUsrWordSet(long);

/************************************************/
/*	GNZvV} (Exception Man)	*/
/************************************************/

SXCALL	long	EXEnVDISPST(void (*)());
SXCALL	long	EXDeVDISPST(void (*)());

/************************************************/
/*	}EX} (Mouse Man)			*/
/************************************************/

SXCALL	void	MSInitCsr(void);
SXCALL	void	MSShowCsr(void);
SXCALL	void	MSHideCsr(void);
SXCALL	void	MSSetCsr(TXcsr **);
SXCALL	void	MSObscureCsr(void);
SXCALL	void	MSShieldCsr(rect *, point_t);
SXCALL	MsRec	*MSGetCurMsr(void);
SXCALL	long	MSMultiGet(void);
SXCALL	long	MSMultiSet(long);

/************************************************/
/*	Aj[V} (Animation Man)	*/
/************************************************/

SXCALL	long	EXAnimStart(long, long, TXcsr **[]);
SXCALL	long	EXAnimEnd(void);
SXCALL	long	EXAnimTest(void);

/************************************************/
/*	L[{[h} (Keyboard Man)		*/
/************************************************/

SXCALL	char	*KBMapGet(KbRec *);
SXCALL	long	KBShiftGet(KbRec *);
SXCALL	long	KBShiftSet(KbRec *, long);
SXCALL	long	KBSimulate(KbRec *, long);
SXCALL	long	KBScan(KbRec *);
SXCALL	long	KBGet(KbRec *);
SXCALL	void	KBEmpty(KbRec *);
SXCALL	KbRec	*KBInit(long, long);
SXCALL	void	KBTini(KbRec *);
SXCALL	KbRec	*KBCurKbrGet(void);
SXCALL	long	KBOldOnGet(KbRec *);
SXCALL	long	KBOldOnSet(KbRec *, long);

/* add 92 07 05 */
SXCALL	long	KBFlagGet(KbRec *);
SXCALL	long	KBFlagSet(KbRec *, long);

/************************************************/
/*	L[} (Key Man)			*/
/************************************************/

SXCALL	void	KMEmpty(KmRec *);
SXCALL	long	KMPost(KmRec *, long, long);
SXCALL	pointer	KMAscJobSet(KmRec *, int (*)());
SXCALL	long	KMSimulate(KmRec *, long);
SXCALL	void	KMTask(KmRec *);
SXCALL	KmRec	*KMInit(long);
SXCALL	void	KMTini(KmRec *);
SXCALL	KmRec	*KMCurKmrGet(void);

/************************************************/
/*	Cxg} (Event Man)		*/
/************************************************/

SXCALL	void	EMInit(void);
SXCALL	long	EMTini(void);
SXCALL	long	EMSet(long, long);
SXCALL	long	EMGet(short, event *);
SXCALL	long	EMScan(short, event *);
SXCALL	long	EMMSLoc(void);
SXCALL	long	EMLBttn(void);
SXCALL	long	EMRBttn(void);
SXCALL	long	EMLStill(void);
SXCALL	long	EMRStill(void);
SXCALL	long	EMLWait(void);
SXCALL	long	EMRWait(void);
SXCALL	long	EMKMapGet(pointer *);
SXCALL	unsigned long	EMSysTime(void);
SXCALL	unsigned long	EMDClickGet(void);
SXCALL	unsigned long	EMBlinkGet(void);
SXCALL	long	EMClean(short, short);
SXCALL	void	EMMaskSet(short);
SXCALL	void	EMDClickSet(unsigned long);
SXCALL	void	EMBlinkSet(unsigned long);
SXCALL	long	EMEnCross(short);
SXCALL	long	EMDeCross(void);

/************************************************/
/*	\[X} (Resource Man)		*/
/************************************************/

SXCALL	void	RMInit(void);
SXCALL	void	RMTini(void);
SXCALL	long	RMResNew(void);					/* _SXCALLPtr */
SXCALL	long	RMRscAdd(long, short, handle, long);		/* _SXCALLPtr */
SXCALL	long	RMRscRemove(long, short);
SXCALL	long	RMTypeRemove(long);
SXCALL	long	RMResDispose(void);
SXCALL	long	RMResOpen(char *);				/* _SXCALLPtr */
SXCALL	long	RMRscGet(long, short);				/* _SXCALLPtr */
SXCALL	long	RMResClose(char *);
SXCALL	long	RMResRemove(void);
SXCALL	void	RMCurResSet(handle);				/* _SXCALLPtr */
SXCALL	long	RMRscRelease(handle);				/* _SXCALLPtr */
SXCALL	long	RMRscDetach(handle);				/* _SXCALLPtr */
SXCALL	long	RMMaxIDGet(long);
SXCALL	long	RMResSave(char *);				/* _SXCALLPtr  */
/*SXCALL	retRMHdltoRsc RMHdlToRsc(handle);*/		/* _SXCALLPtr  */
SXCALL	handle	RMCurResGet(void);
SXCALL	long	RMLastResGet(void);				/* _SXCALLPtr  */
SXCALL	long	RMResLoad(void);

/* add 92 07 05 */
SXCALL	long	RMResLinkGet(handle);
SXCALL	long	RMResTypeList(long *, long ***, handle);
SXCALL	long	RMReslDList(long *, short ***, handle, long);

/************************************************/
/*	Ot} (Graph Man)			*/
/************************************************/

SXCALL	long	GMOpenGraph(short, graph *);			/* _SXCALLPtr */
SXCALL	long	GMCloseGraph(graph *);				/* _SXCALLPtr */
SXCALL	long	GMInitGraph(graph *);				/* _SXCALLPtr */
SXCALL	long	GMSetGraph(graph *);				/* _SXCALLPtr */
SXCALL	long	GMGetGraph(void);				/* _SXCALLPtr */
SXCALL	long	GMCopyGraph(graph *, graph *);			/* _SXCALLPtr */
SXCALL	long	GMMoveGraph(point_t);				/* _SXCALLPtr */
SXCALL	long	GMSlideGraph(point_t);				/* _SXCALLPtr */
SXCALL	long	GMSetClip(region **);				/* _SXCALLPtr */
SXCALL	long	GMGetClip(region **);				/* _SXCALLPtr */
SXCALL	long	GMClipRect(rect *);
SXCALL	long	GMSetHome(point_t);
SXCALL	long	GMSetGraphSize(point_t);
SXCALL	long	GMSetBitmap(bitmap *);
SXCALL	long	GMLocalToGlobal(point_t);			/* _SXCALLPtr */
SXCALL	long	GMGlobalToLocal(point_t);			/* _SXCALLPtr */
SXCALL	void	GMInitPen(void);
SXCALL	long	GMPenShow(void);				/* _SXCALLPtr */
SXCALL	long	GMPenHide(void);				/* _SXCALLPtr */
SXCALL	long	GMPenSize(point_t);
SXCALL	short	GMPenMode(short);
SXCALL	long	GMPenPat(unsigned short *);			/* _SXCALLPtr */
SXCALL	long	GMExPat(void *);
SXCALL	short	GMForeColor(short);
SXCALL	short	GMBackColor(short);
SXCALL	short	GMAPage(short);
SXCALL	long	GMGetLoc(void);
SXCALL	void	GMGetPen(pen *);
SXCALL	void	GMSetPen(pen *);
SXCALL	void	GMInitialize(void);
SXCALL	long	GMNullRect(rect *);				/* _SXCALLPtr */
SXCALL	long	GMSizeRect(rect *, point_t);			/* _SXCALLPtr */
SXCALL	long	GMAndRects(short, rect *, rect *, rect *, ...);
SXCALL	long	GMMoveRect(rect *, point_t);			/* _SXCALLPtr */
SXCALL	long	GMSlideRect(rect *, point_t);			/* _SXCALLPtr */
SXCALL	long	GMInsetRect(rect *, point_t);			/* _SXCALLPtr */
SXCALL	long	GMAndRect(rect *, rect *, rect *);		/* _SXCALLPtr */
SXCALL	long	GMOrRect(rect *, rect *, rect *);		/* _SXCALLPtr */
SXCALL	long	GMPtInRect(rect *, point_t);
SXCALL	long	GMEqualRect(rect *, rect *);
SXCALL	long	GMEmptyRect(rect *);
SXCALL	long	GMAdjustRect(rect *, rect *, rect *);		/* _SXCALLPtr */
SXCALL	long	GMNewRgn(void);					/* _SXCALLPtr */
SXCALL	long	GMDisposeRgn(region **);
SXCALL	long	GMOpenRgn(void);
SXCALL	long	GMCloseRgn(region **);				/* _SXCALLPtr */
SXCALL	long	GMNullRgn(region **);				/* _SXCALLPtr */
SXCALL	long	GMRectRgn(region **, rect *);			/* _SXCALLPtr */
SXCALL	long	GMCopyRgn(region **, region **);		/* _SXCALLPtr */
SXCALL	long	GMMoveRgn(region **, point_t);			/* _SXCALLPtr */
SXCALL	long	GMSlideRgn(region **, point_t);			/* _SXCALLPtr */
SXCALL	long	GMInsetRgn(region **, point_t);			/* _SXCALLPtr */
SXCALL	long	GMAndRgn(region **, region **, region **);	/* _SXCALLPtr */
SXCALL	long	GMOrRgn(region **, region **, region **);	/* _SXCALLPtr */
SXCALL	long	GMDiffRgn(region **, region **, region **);	/* _SXCALLPtr */
SXCALL	long	GMXorRgn(region **, region **, region **);	/* _SXCALLPtr */
SXCALL	long	GMPtInRgn(region **, point_t);
SXCALL	long	GMRectInRgn(region **, rect *);
SXCALL	long	GMEqualRgn(region **, region **);
SXCALL	long	GMEmptyRgn(region **);
SXCALL	long	GMInitBitmap(short, bitmap *);			/* _SXCALLPtr */
SXCALL	void	GMMove(point_t);
SXCALL	void	GMMoveRel(point_t);
SXCALL	long	GMLine(point_t);
SXCALL	long	GMLineRel(point_t);
SXCALL	long	GMFrameRect(rect *);
SXCALL	long	GMFillRect(rect *);
SXCALL	long	GMFrameOval(rect *);
SXCALL	long	GMFillOval(rect *);
SXCALL	long	GMFrameRRect(rect *, point_t);
SXCALL	long	GMFillRRect(rect *, point_t);
SXCALL	long	GMFrameRgn(region **);
SXCALL	long	GMFillRgn(region **);
SXCALL	long	GMScroll(rect *, point_t, region **);		/* _SXCALLPtr */
SXCALL	long	GMCopy(bitmap *, bitmap *, rect *, rect *, short, region **);
SXCALL	long	GMCopyMask(bitmap *, bitmap *, bitmap *, rect *, rect *, rect *);
SXCALL	long	GMPlotImg(unsigned short *, rect *, short);
SXCALL	long	GMPutRImg(rectImg *, point_t);
SXCALL	long	GMDupHImg(unsigned short *, point_t, short, short);
SXCALL	long	GMDupVImg(unsigned short *, point_t, short, short);
SXCALL	long	GMDupHRImg(rectImg *, point_t, short);
SXCALL	long	GMDupVRImg(rectImg *, point_t, short);
SXCALL	short	GMFontKind(short);
SXCALL	short	GMFontFace(short);
SXCALL	long	GMFontMode(short);
SXCALL	long	GMFontSize(point_t);
SXCALL	long	GMDrawChar(short);
SXCALL	long	GMDrawStrL(LASCII *);
SXCALL	long	GMDrawStr(char *, long, short);
SXCALL	long	GMDrawStrZ(char *);
SXCALL	long	GMCharWidth(short);
SXCALL	short	GMStrLWidth(LASCII *);
SXCALL	long	GMStrWidth(char *, long, short);
SXCALL	long	GMStrLength(char *, long, short);
SXCALL	long	GMFontInfo(void);
SXCALL	long	GMOpenScript(region **);
SXCALL	long	GMCloseScript(gScript **);			/* _SXCALLPtr */
SXCALL	long	GMDisposeScript(gScript **);
SXCALL	long	GMDrawScript(gScript **, rect *);
SXCALL	long	GMGetScript(gScript **, long);			/* _SXCALLPtr */
SXCALL	long	GMShadowStrZ(char *, point_t);
SXCALL	long	GMShadowRect(rect *);
SXCALL	long	GMInvertRect(rect *, short);
SXCALL	long	GMInvertBits(point_t, bitmap *);
SXCALL	long	GMMapPt(point_t, rect *, rect *);
SXCALL	long	GMMapRect(rect *, rect *, rect *);		/* _SXCALLPtr */
SXCALL	long	GMMapRgn(region **, rect *, rect *);		/* _SXCALLPtr */
SXCALL	long	GMScalePt(point_t, rect *, rect *);
SXCALL	void	GMInitPalet(void);
SXCALL	void	GMDrawG16(tx16 *, point_t);
SXCALL	short	GMGetPixel(bitmap *, point_t);
SXCALL	long	GMCalcMask(short *, short *, short, short, short, short);	/* _SXCALLPtr */
SXCALL	long	GMCalcFrame(short *, short *, short, short, short, short);	/* _SXCALLPtr */
SXCALL	long	GMGetFontTable(void);				/* _SXCALLPtr */
SXCALL	long	GMStrZWidth(char *);

/* add 92 07 05 */
SXCALL	long	GMImgToRgn(region **, bitmap *, rect *);	 /* SXCALLPtr */
SXCALL	long	GMFrameArc(rect *, short, short);
SXCALL	long	GMFillArc(rect *, short, short);
SXCALL	long	GMFramePoly(polygon **);
SXCALL	long	GMFillPoly(polygon **);
SXCALL	long	GMOpenPoly(void);
SXCALL	long	GMClosePoly(polygon **);			 /* SXCALLPtr */
SXCALL	long	GMDisposePoly(polygon **);
SXCALL	long	GMMapPoly(polygon **, rect *, rect *);		 /* SXCALLPtr */
SXCALL	long	GMCopyStdProc(gProc *); 			 /* SXCALLPtr */
SXCALL	long	GMCopyStdProc(gProc *);
SXCALL	long	GMTransImg(bitmap *, bitmap *, rect *, rect *);
SXCALL	long	GMFillRImg(rectImg *, point_t);
SXCALL	long	GMFillImg(tx16 *, rect *);
SXCALL	long	GMSlidedRgn(region **, region **, point_t);
SXCALL	long	GMPaintRgn(region **, bitmap *, point_t);	 /* SXCALLPtr */
SXCALL	long	GMSetRgnLine(short);
SXCALL	long	GMGetRgnLine(void);
SXCALL	long	GMInitGraphMode(short);
SXCALL	long	GMCurFont(void);  				/* SXCALLPtr */
SXCALL	point_t	GMGetScrnSize(void);
SXCALL	long	GMExgGraph(graph *);  				/* SXCALLPtr */
SXCALL	long	GMExgBitmap(bitmap *); 				/* SXCALLPtr */
SXCALL	long	GMGetBitmap(void);				/* SXCALLPtr */
SXCALL	long	GMCalcBitmap(bitmap *); 			/* SXCALLPtr */
SXCALL	long	GMCalcScrnSize(bitmap *);
SXCALL	long	GMNewBits(short, rect *, short); /* SXCALLPtr */
SXCALL	long	GMDisposeBits(bits **);
SXCALL	long	GMLockBits(bits **); /* SXCALLPtr */
SXCALL	long	GMUnlockBits(bits **); /* SXCALLPtr */
SXCALL	long	GMItalicRect(rect *);
SXCALL	long	GMItalicRgn(region **, rect *); /* SXCALLPtr */
SXCALL	long	GMFreeBits(bits **); /* SXCALLPtr */
SXCALL	long	GMCalcGraph(graph *); /* SXCALLPtr */
SXCALL	long	GMPackImage(void *, void *, long); /* SXCALLPtr */
SXCALL	long	GMUnpackImage(void *, void *, long); /* SXCALLPtr */
SXCALL	long	GMAdjustPt(point_t, rect *);
SXCALL	long	GMPutImg(tx16 *, rect *);
SXCALL	long	GMCenterRect(rect *, rect *, long, short); /* SXCALLPtr */
SXCALL	long	GMScrewRect(rect *);
SXCALL	long	GMAndRectRgn(region **, region **, rect *); /* SXCALLPtr */
SXCALL	long	GMOrRectRgn(region **, region **, rect *); /* SXCALLPtr */
SXCALL	long	GMDiffRectRgn(region **, region **, rect *); /* SXCALLPtr */
SXCALL	long	GMXorRectRgn(region **, region **, rect *); /* SXCALLPtr */
SXCALL	long	GMCharKind(short);
SXCALL	long	GMDiffRgnRect(region **, rect *, region **); /* SXCALLPtr */
SXCALL	long	GMAddFont(fontLink *);
SXCALL	long	GMRemoveFont(short);
SXCALL	fontLink *GMGetFontLink(void); /* SXCALLPtr */
SXCALL	hProc	*GMGetHProcTbl(void);  /* SXCALLPtr */
SXCALL	gProc	*GMGetStdProcTbl(void); /* SXCALLPtr */
SXCALL	fontProc	*GMGetFontProcTbl(void); /* SXCALLPtr */
SXCALL	rgnProc	*GMGetRgnProcTbl(void); /* SXCALLPtr */

/************************************************/
/*	EBhE} (Window Man)		*/
/************************************************/

SXCALL	long	WMInit(void);

/* _SXCALLPtr */
SXCALL	long
WMOpen(window *, rect *, LASCII *, short, short, window *, short, long);

SXCALL	long	WMRefer(short, window *, window *);	/* _SXCALLPtr */
SXCALL	long	WMClose(window *);
SXCALL	long	WMDispose(window *);
SXCALL	long	WMFind(point_t);	/* _SXCALLPtr */
SXCALL	long	WMSelect(window *);
SXCALL	long	WMCarry(window *, window *);
SXCALL	long	WMShine(window *, short);
SXCALL	long	WMMove(window *, point_t, short);
SXCALL	long	WMSize(window *, point_t, short);
SXCALL	long	WMGrow(window *, point_t, rect *);
SXCALL	long	WMDrag(window *, point_t, rect *);
SXCALL	long	WMZoom(window *, short, short);
SXCALL	long	WMShow(window *);
SXCALL	long	WMHide(window *);
SXCALL	long	WMShowHide(window *, short);
SXCALL	long	WMCheckBox(window *, point_t, short);
SXCALL	long	WMCheckCBox(window *, point_t);
SXCALL	long	WMDrawGBox(window *);
SXCALL	long	WMUpdate(window *);
SXCALL	long	WMUpdtOver(window *);
SXCALL	void	WMActive(void);		/* _SXCALLPtr */
SXCALL	long	WMAddRect(rect *);
SXCALL	long	WMAddRgn(region **);
SXCALL	long	WMSubRect(rect *);
SXCALL	long	WMSubRgn(region **);
SXCALL	long	WMGScriptSet(gScript **);
SXCALL	void	WMGScriptGet(void);	/* _SXCALLPtr */
SXCALL	long	WMTitleSet(window *, LASCII *);
SXCALL	long	WMTitleGet(window *, LASCII *);
SXCALL	long	WMTIDSet(long);
SXCALL	long	WMTIDGet(void);		/* _SXCALLPtr */
SXCALL	void	WMGetDTGS(void);	/* _SXCALLPtr */
SXCALL	long	WMDragRgn(region **, point_t, rect *, rect *, short, void (*)());

/* add 92 07 05 */
SXCALL	long	WMSelect2(window *,window *);
SXCALL	long	WMOptionGet(void);
SXCALL	void	WMOptionSet(short);

/************************************************/
/*	TuEBhE} (SubWindow Man)	*/
/************************************************/

/* add 92 07 16 */
SXCALL	long	WSOpen(subWindow *, region **, long );	/* _SXCALLPtr */
SXCALL	long	WSClose(subWindow *);
SXCALL	long	WSDispose(subWindow *);
SXCALL	long	WSEnlist(subWindow *);
SXCALL	long	WSDelist(subWindow *);

/************************************************/
/*	j[} (Menu Man)			*/
/************************************************/

SXCALL	void	MNInit(void);
SXCALL	menu	**MNRefer(short);	/* _SXCALLPtr */
SXCALL	long	MNSelect(menu **, point_t);
SXCALL	long	MNConvert(menu **, char *, short);	/* _SXCALLPtr */

/************************************************/
/*	Rg[} (Control Man)		*/
/************************************************/
/* _SXCALLPtr */
SXCALL	long	CMOpen(window *, rect *, LASCII *, short, short, short, short, short, long);

SXCALL	long	CMDispose(control **);
SXCALL	long	CMKill(window *);
SXCALL	long	CMHide(control **);
SXCALL	long	CMShow(control **);
SXCALL	long	CMDraw(window *);
SXCALL	long	CMDrawOne(control **);
SXCALL	long	CMValueSet(control **, short);
SXCALL	long	CMValueGet(control **);
SXCALL	long	CMMinSet(control **, short);
SXCALL	long	CMMinGet(control **);
SXCALL	long	CMMaxSet(control **, short);
SXCALL	long	CMMaxGet(control **);
SXCALL	long	CMMove(control **, point_t);
SXCALL	long	CMSize(control **, point_t);
SXCALL	long	CMShine(control **, short);
SXCALL	long	CMFind(point_t, window *);	/* _SXCALLPtr */
SXCALL	short	CMCheck(control **, point_t, void (*)());
SXCALL	long	CMRefer(short, window *);	 	/* _SXCALLPtr */
SXCALL	long	CMTitleGet(control **, LASCII *);
SXCALL	long	CMDraws(window *, region **);
SXCALL	long	CMTitleSet(control **, LASCII *);
/* add 92 07 05 */
SXCALL	long	CMOptionGet(control **);
SXCALL	void	CMOptionSet(control **);
SXCALL	long	CMUserGet(control **);
SXCALL	void	CMUserSet(control **, long);
SXCALL	void	*CMProcGet(control **);
SXCALL	void	CMProcSet(control **, void *);
SXCALL	long	CMDefDataGet(control **);
SXCALL	void	CMDefDataSet(control **, long);

/************************************************/
/*	_CAO} (Dialog Man)		*/
/************************************************/

SXCALL	void	DMInit(void);
SXCALL	void	DMFontSet(short);

/* _SXCALLPtr */
SXCALL	long	DMOpen(dialog *, rect *, LASCII *, short, short, window *, short, long, dlgIList **);

SXCALL	long	DMRefer(short, dialog *, window *);	/* _SXCALLPtr */
SXCALL	long	DMClose(dialog *);
SXCALL	long	DMDispose(dialog *);
SXCALL	long	DMControl(void (*)());
SXCALL	long	DMDraw(dialog *);
SXCALL	long	DIGet(dialog *, short, short *, int *, rect **);
SXCALL	long	DISet(dialog *, short, short, handle, rect *);
SXCALL	long	DITGet(short, handle, LASCII *);	/* _SXCALLPtr */
SXCALL	long	DITSet(short, handle, LASCII *);	/* _SXCALLPtr */
SXCALL	long	DITSelect(dialog *, short, long, long);
SXCALL	long	DIUpdate(dialog *, region **);
SXCALL	long	DMBeep(short);
SXCALL	long	DIHide(dialog *, short);
SXCALL	long	DIShow(dialog *, short);
SXCALL	long	DMError(short, char *);
SXCALL	long	DMWaitOpen(void);	/* _SXCALLPtr */
SXCALL	long	DMWaitClose(void);
SXCALL	long	DMWaitWhile(void);	/* _SXCALLPtr */

/************************************************/
/*	eLXg} (Text Man)			*/
/************************************************/

SXCALL	long	TMInit(void);
SXCALL	long	TMNew(rect *, rect *);			/* _SXCALLPtr */
SXCALL	long	TMSetRect(tEdit **, rect *, rect *);
SXCALL	long	TMChangeText(tEdit **, char *, long);
SXCALL	long	TMIdle(tEdit **);
SXCALL	long	TMCaret(tEdit **, short);
SXCALL	long	TMDispose(tEdit **);
SXCALL	long	TMUpDate(tEdit **, rect *);
SXCALL	long	TMSetText(tEdit **, char *, long);
SXCALL	long	TMGetText(tEdit **, char *, long);	/* _SXCALLPtr */
SXCALL	long	TMSetSelect(tEdit **, long, long, long);
SXCALL	long	TMKey(tEdit **, short);
SXCALL	long	TMStr(tEdit **, char *, long);
SXCALL	long	TMPinScroll(tEdit **);
SXCALL	long	TMClick(tEdit **, point_t, short);
SXCALL	long	TMEvent(tEdit **, event *);
SXCALL	long	TMCut(tEdit **);
SXCALL	long	TMCopy(tEdit **);
SXCALL	long	TMPaste(tEdit **);
SXCALL	long	TMDelete(tEdit **);
SXCALL	long	TMFromScrap(void);
SXCALL	long	TMToScrap(void);
SXCALL	long	TMScrapHandle(void);			/* _SXCALLPtr */
SXCALL	long	TMGetScrapLen(void);
SXCALL	long	TMTextBox2(char *, long, rect *, short, short);
SXCALL	long	TMOpen(char *, long, rect *, short, short);
SXCALL	long	TMNew2(rect *, rect *,graph *);		/* _SXCALLPtr */
SXCALL	long	TMHide(tEdit **);
/* add 92 07 16 */
SXCALL	long	TMCalText(tEdit **);
SXCALL	long	TMInsert(tEdit **, char *, long);
SXCALL	long	TMCacheON(tEdit **, long);
SXCALL	long	TMCacheOFF(tEdit **);
SXCALL	long	TMCacheFlush(tEdit **);
SXCALL	long	TMShow(tEdit **);
SXCALL	long	TMHide(tEdit **);
SXCALL	long	TMSelShow(tEdit **);
SXCALL	long	TMSelHide(tEdit **);
SXCALL	long	TMSearchStrF(tEdit **, char *, long, long, long, void *);	/* _SXCALLPtr */
SXCALL	long	TMSearchStrB(tEdit **, char *, long, long, long, void *);	/* _SXCALLPtr */
SXCALL	long	TMTextWidth2(tEdit **, char *, long, short, short);
SXCALL	long	TMDrawText2(tEdit **, char *, long, short, short, short);
SXCALL	long	TMUpDate2(tEdit **, teHis *);
SXCALL	long	TMUpDate3(tEdit **, rect *);
SXCALL	long	TMCalCOLine(tEdit **, teColumn *, long);
SXCALL	long	TMCalLine(tEdit **, teColumn *, long, short);
SXCALL	long	TMLeftSel(tEdit **);
SXCALL	long	TMRightSel(tEdit **);
SXCALL	long	TMPointSel(tEdit **, long, long, short);
SXCALL	long	TMOffsetSel(tEdit **, long, short);
SXCALL	long	TMPointToLine(tEdit **, long, long, teColumn *);	/* _SXCALLPtr */
SXCALL	long	TMCalSelPoint(tEdit **);
SXCALL	long	TMSetView(tEdit **, rect *);
SXCALL	long	TMScroll(tEdit **, long, long);
SXCALL	long	TMPointScroll(tEdit **, long, long);
SXCALL	long	TMStr2(tEdit **, char *, long, teHis *);
SXCALL	long	TMKeyToAsk(tEdit **, event *);
SXCALL	long	TMNextCode(tEdit **, short, short);
SXCALL	long	TMSetTextH(tEdit **, char **, long);
SXCALL	long	TMNextCodeIn(tEdit **, short);
SXCALL	long	TMSelReverse(tEdit **, long, long);
SXCALL	long	TMTini(void);
SXCALL	long	TMSetSelCal(tEdit **, long, long, long);
SXCALL	long	TMActivate2(tEdit **);
SXCALL	long	TMDeactivate2(tEdit **);
SXCALL	long	TMCatchSel(tEdit **, long, long, long);
SXCALL	long	TMCalPoint2(tEdit **, long, tPosInfo *);	/* _SXCALLPtr */
SXCALL	long	TMISZen(tEdit **, long);	/* _SXCALLPtr */
SXCALL	long	TMSetDestOffset(tEdit **, long, long);
SXCALL	long	TMGetDestOffset(tEdit **, tOffset *);
SXCALL	long	TMGetSelect(tEdit **, tSelectInfo *);
SXCALL	long	TMEventW(tEdit **, event *);
	long	TMUpDateExist(tEdit **, long);	/* Lib! */

/************************************************/
/*	^XN} (Task Man)			*/
/************************************************/

SXCALL	long	TSInitTsk(void *, void *, void *, short, short);	/* _SXCALLPtr */
SXCALL	long	TSInitCrtM(void);
SXCALL	long	TSTiniCrtM(short);
SXCALL	long	TSFock(short, long, char *, char *, long, short);
SXCALL	long	TSFockB(short, char *, char *, char *, char *);
SXCALL	long	TSFockSItem(void **);
SXCALL	long	TSFockIcon(icstate *, short, char *, char *);
SXCALL	long	TSEventAvail(short, tsevent *);
SXCALL	long	TSGetEvent(short, tsevent *);
SXCALL	long	TSPostEventTsk(long, long, short, short);
SXCALL	long	TSGetTdb(task *, short);
SXCALL	long	TSSetTdb(task *, short);
SXCALL	long	TSGetWindowPos(void);
SXCALL	long	TSCommunicate(short, tsevent *, short);
SXCALL	long	TSGetID(void);
SXCALL	long	TSMakeEvent(long, long, short, short, tsevent *);
SXCALL	long	TSGetStartMode(void);
SXCALL	void	TSSetStartMode(short);
SXCALL	long	TSOpen(char *, short);
SXCALL	long	TSClose(short);
SXCALL	long	TSRmDirH(char **);
SXCALL	long	TSCopyH(char **, char **);
SXCALL	long	TSMkDirH(char **);
SXCALL	long	TSMoveH(char **, char **);
SXCALL	long	TSCreate(char *, short);
SXCALL	long	TSDeleteH(char **);
SXCALL	long	TSTrash(char **, char **);
SXCALL	long	TSFiles(void *, char *, short);
SXCALL	long	TSNFiles(void *, char *, short);
SXCALL	long	TSCopyP(char *, char *);
SXCALL	long	TSDeleteP(char *);
SXCALL	long	TSRmDirP(char *);
SXCALL	long	TSMkDirP(char *);
SXCALL	long	TSMoveP(char *, char *);
SXCALL	long	TSChMod(char *, short);
SXCALL	long	TSWhatFile(tsevent *, char *);
SXCALL	long	TSDeleteVoname(char *);
SXCALL	long	TSCreateVoname(char *);
SXCALL	long	TSSearchFileND(char *, char *, char *);
SXCALL	long	TSGetOpen(void);	/* _SXCALLPtr */
SXCALL	long	TSZeroDrag(void);
SXCALL	long	TSPutDrag(int, void **);
SXCALL	long	TSGetDrag(void);	/* _SXCALLPtr */
SXCALL	long	TSBeginDrag(point_t);
SXCALL	long	TSEndDrag(short);
SXCALL	long	TSHideDrag(void);
SXCALL	long	TSShowDrag(void);
SXCALL	long	TSZeroScrap(void);
SXCALL	long	TSPutScrap(long, void **);
SXCALL	long	TSGetScrap(void);	/* _SXCALLPtr */
SXCALL	long	TSSearchTrashpath(char **);
SXCALL	long	TSSearchTrashfile(char **);
SXCALL	long	TSEmptyTrash(void);
SXCALL	long	TSSearchdpb(short, short);	/* _SXCALLPtr */
SXCALL	long	TSDrvctrl(short, short);
SXCALL	long	TSDrvctrl2(short, short);
SXCALL	long	SXCallWindM(window *, tsevent *);
SXCALL	long	SXCallCtrlM(window *, tsevent *, void **, void **, rect *);	/* _SXCALLPtr */
SXCALL	long	SXInvalScBar(window *);
SXCALL	long	SXValidScBar(window *);
SXCALL	long	TSISRecToStr(icstate *, char *);	/* _SXCALLPtr */
SXCALL	long	TSCreateISFile(char **, icstate *);	/* _SXCALLPtr */
SXCALL	long	SXFileConnPath(char *, char *);
SXCALL	long	SXFileInPath(char *, char *);
SXCALL	long	SXFnamecmp(char *, short, char *, short);
SXCALL	long	SXSearchFname(char *);			/* _SXCALLPtr */
SXCALL	void	SXStoLower(char *, short);
SXCALL	void	SXStoUpper(char *, short);
SXCALL	void	SXStoUpper2(char *, char *, short);
SXCALL	long	SXVer(void);
SXCALL	long	TSTakeParam(LASCII *, rect *, char *, short, char **);	/* _SXCALLPtr */
SXCALL	long	TSFindTskn(char *, short);
SXCALL	long	TSDriveCheckAll(short);
SXCALL	long	TSDriveCheck(short);
SXCALL	long	TSISRecToExec(icstate *, char *, LASCII *);
SXCALL	long	TSGetDtopMode(void);
SXCALL	void	TSSetDtopMode(short);
SXCALL	long	TSSearchOpen(char *, short, short);	/* _SXCALLPtr */
SXCALL	short	TSFindOwn(void);
SXCALL	long	TSCommunicateS(short, tsevent *, short);
SXCALL	long	TSSearchFile2(short, void *, char *, char *, char *);
SXCALL	long	TSSearchFile(char *, char *, char *);
SXCALL	long	SXStrCmp(char *, char *, short);
SXCALL	long	TSCreateISBadge(icstate *, short, short);
SXCALL	long	TSGetCMDS(short, char *);	/* _SXCALLPtr */
SXCALL	long	TSFockCM(short, long, char *, char *, char *);
SXCALL	long	TSTiniTsk(void);
SXCALL	void	TSExit(long);
/* add 92 07 16 */
SXCALL	long	TSPostEventTsk2(long, long, short, UnionMode, short);
SXCALL	long	TSAnswer(tsevent *);
SXCALL	long	TSSendMes(short, tsevent *);
SXCALL	long	TSGetMes(tsevent *, short);
SXCALL	long	TSInitTsk2(void *, void *, char *, UnionMode, short, char *);	/* _SXCALLPtr */
SXCALL	long	SXCallWindM2(window *, tsevent *, rect *);
SXCALL	long	TSBeginDrag2(long, void *, long);
SXCALL	long	SXGetVector(short);	/* _SXCALLPtr */
SXCALL	long	SXSetVector(short, void *);	/* _SXCALLPtr */
SXCALL	long	TSCellToStr(cell **, char *, long);	/* _SXCALLPtr */
SXCALL	void	SXLockFSX(void);
SXCALL	void	SXUnlockFSX(void);
SXCALL	long	TSFockMode(char *, char *);
SXCALL	long	TSSetGraphMode(short, short);
SXCALL	long	TSGetGraphMode(void);	/* _SXCALLPtr */
SXCALL	long	SXGetDispRect(rect *);
SXCALL	long	SXSRAMVer(void);
SXCALL	void	SXSRAMReset(void);
SXCALL	long	SXSRAMCheck(void);


SXCALL	long	DOSREAD (short, void *, long);
SXCALL	long	DOSWRITE (short, void *, long);
SXCALL	long	DOSSEEK (short, long, short);

	long	TSSetAbort(void (*)(), long);

/************************************************/
/*	vg}(Print Man)			*/
/************************************************/

SXCALL	long	PMInit(void);
SXCALL	long	PMTini(void);
SXCALL	long	PMOpen(short);
SXCALL	long	PMClose(void);
SXCALL	long	PMSetDefault(prRec **);	/* _SXCALLPtr */
SXCALL	long	PMValidate(prRec **);
SXCALL	long	PMImageDialog(prRec **);
SXCALL	long	PMStrDialog(prRec **);
SXCALL	long	PMEnvCopy(prRec **, prRec **);
SXCALL	long	PMJobCopy(prRec **, prRec **);
SXCALL	long	PMOpenImage(prRec **);	/* _SXCALLPtr */
SXCALL	long	PMRecordPage(rect *);
#define	PMPrintPage(a)	PMPrintPage_(0)
SXCALL	long	PMPrintPage_(long);
SXCALL	long	PMCancelPage(void);
SXCALL	long	PMAction(short);
SXCALL	long	PMCloseImage(void);
SXCALL	long	PMDrawString(prRec **, char **, long, long);
SXCALL	long	PMVer(void);
SXCALL	long	PMDrvrVer(void);
SXCALL	long	PMDrvrCtrl(long, long, long, long);
SXCALL	long	PMDrvrID(void);
SXCALL	long	PMDrvrHdl(void);	/* _SXCALLPtr */
SXCALL	long	PMMaxRect(prRec **, short, rect *);	/* _SXCALLPtr */
SXCALL	long	PMSaveEnv(prRec **);
SXCALL	long	PMReady(prRec **);
SXCALL	long	PMProcPrint(prRec **, void *);
SXCALL	long	PMDrvrInfo(short, prtdInfo *);	/* _SXCALLPtr */

SXCALL	long	GMGetScrKind (void);

#endif
#endif


